
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")
green_beans = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="green_beans")
bowls_of_pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
black_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="black_beans")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")


# Set objective function
m.setObjective(5.25 * granola_bars + 9.12 * green_beans + 3.37 * bowls_of_pasta + 4.29 * black_beans + 1.67 * oreos, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * granola_bars + 8 * green_beans + 3 * bowls_of_pasta + 3 * black_beans + 10 * oreos <= 268, "c0")
m.addConstr(3 * granola_bars + 3 * green_beans + 4 * bowls_of_pasta + 8 * black_beans + 1 * oreos <= 236, "c1")
m.addConstr(3 * granola_bars + 8 * green_beans + 4 * bowls_of_pasta + 3 * black_beans + 11 * oreos <= 241, "c2")
m.addConstr(4 * granola_bars + 11 * green_beans + 3 * bowls_of_pasta + 5 * black_beans + 8 * oreos <= 110, "c3")
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

