
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="granola_bars", lb=0)
    x2 = model.addVar(name="green_beans", lb=0, integrality=1)
    x3 = model.addVar(name="bowls_of_pasta", lb=0)
    x4 = model.addVar(name="black_beans", lb=0)
    x5 = model.addVar(name="oreos", lb=0)

    # Objective function
    model.setObjective(5.25*x1 + 9.12*x2 + 3.37*x3 + 4.29*x4 + 1.67*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6*x1 + 8*x2 + 3*x3 + 3*x4 + 10*x5 <= 268)
    model.addConstr(6*x1 + 8*x2 >= 39)
    model.addConstr(3*x3 + 3*x4 >= 36)
    model.addConstr(3*x1 + 8*x2 >= 39)
    model.addConstr(8*x2 + 3*x4 + 10*x5 >= 45)
    model.addConstr(6*x1 + 8*x2 + 3*x3 + 3*x4 + 10*x5 >= 45)

    # Add all other constraints...

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Granola bars: ", x1.varValue)
        print("Green beans: ", x2.varValue)
        print("Bowls of pasta: ", x3.varValue)
        print("Black beans: ", x4.varValue)
        print("Oreos: ", x5.varValue)
        print("Objective: ", model.objVal)
    else:
        print("No optimal solution found.")

optimization_problem()
