
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
paul_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")

# Set objective function
m.setObjective(9 * laura_hours + 6 * paul_hours + 5 * bill_hours + 3 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * laura_hours + 14 * mary_hours >= 46)
m.addConstr(10 * laura_hours + 6 * bill_hours >= 49)
m.addConstr(12 * paul_hours + 6 * bill_hours + 14 * mary_hours >= 30)
m.addConstr(8 * paul_hours + 3 * mary_hours >= 47)
m.addConstr(9 * laura_hours + 12 * bill_hours + 3 * mary_hours >= 49)
m.addConstr(7 * laura_hours + 9 * bill_hours >= 66)
m.addConstr(14 * paul_hours + 9 * bill_hours >= 27)
m.addConstr(9 * bill_hours + 1 * mary_hours >= 47)
m.addConstr(10 * laura_hours + 6 * bill_hours <= 142)
m.addConstr(12 * paul_hours + 14 * mary_hours <= 232)
m.addConstr(12 * paul_hours + 6 * bill_hours <= 153)
m.addConstr(10 * laura_hours + 6 * bill_hours + 14 * mary_hours <= 172)
m.addConstr(10 * laura_hours + 12 * paul_hours + 6 * bill_hours <= 138)
m.addConstr(10 * laura_hours + 12 * paul_hours + 6 * bill_hours + 14 * mary_hours <= 138)
m.addConstr(6 * laura_hours + 7 * bill_hours <= 129)
m.addConstr(6 * laura_hours + 8 * paul_hours <= 179)
m.addConstr(6 * laura_hours + 11 * mary_hours <= 195)
m.addConstr(8 * paul_hours + 11 * mary_hours <= 240)
m.addConstr(8 * paul_hours + 7 * bill_hours <= 164)
m.addConstr(8 * paul_hours + 7 * bill_hours + 11 * mary_hours <= 174)
m.addConstr(6 * laura_hours + 8 * paul_hours + 7 * bill_hours + 11 * mary_hours <= 174)
m.addConstr(8 * paul_hours + 12 * bill_hours <= 177)
m.addConstr(8 * paul_hours + 3 * mary_hours <= 185)
m.addConstr(9 * laura_hours + 8 * paul_hours + 12 * bill_hours + 3 * mary_hours <= 185)
m.addConstr(7 * laura_hours + 9 * bill_hours <= 272)
m.addConstr(9 * bill_hours + 1 * mary_hours <= 146)
m.addConstr(14 * paul_hours + 1 * mary_hours <= 222)
m.addConstr(7 * laura_hours + 14 * paul_hours + 9 * bill_hours + 1 * mary_hours <= 222)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

