
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Laura
x1 = m.addVar(name="x1", lb=0)  # hours worked by Paul
x2 = m.addVar(name="x2", lb=0)  # hours worked by Bill
x3 = m.addVar(name="x3", lb=0)  # hours worked by Mary

# Define the objective function
m.setObjective(9 * x0 + 6 * x1 + 5 * x2 + 3 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * x0 + 14 * x3 >= 46)
m.addConstr(10 * x0 + 6 * x2 >= 49)
m.addConstr(12 * x1 + 6 * x2 + 14 * x3 >= 30)
m.addConstr(8 * x1 + 3 * x3 >= 47)
m.addConstr(9 * x0 + 12 * x2 + 3 * x3 >= 49)
m.addConstr(7 * x0 + 9 * x2 >= 66)
m.addConstr(14 * x1 + 9 * x2 >= 27)
m.addConstr(9 * x2 + 1 * x3 >= 47)
m.addConstr(10 * x0 + 6 * x2 <= 142)
m.addConstr(12 * x1 + 14 * x3 <= 232)
m.addConstr(12 * x1 + 6 * x2 <= 153)
m.addConstr(10 * x0 + 6 * x2 + 14 * x3 <= 172)
m.addConstr(10 * x0 + 12 * x1 + 6 * x2 <= 138)
m.addConstr(10 * x0 + 12 * x1 + 6 * x2 + 14 * x3 <= 138)
m.addConstr(6 * x0 + 7 * x2 <= 129)
m.addConstr(6 * x0 + 8 * x1 <= 179)
m.addConstr(6 * x0 + 11 * x3 <= 195)
m.addConstr(8 * x1 + 11 * x3 <= 240)
m.addConstr(8 * x1 + 7 * x2 <= 164)
m.addConstr(8 * x1 + 7 * x2 + 11 * x3 <= 174)
m.addConstr(6 * x0 + 8 * x1 + 7 * x2 + 11 * x3 <= 174)
m.addConstr(8 * x1 + 12 * x2 <= 177)
m.addConstr(8 * x1 + 3 * x3 <= 185)
m.addConstr(9 * x0 + 8 * x1 + 12 * x2 + 3 * x3 <= 185)
m.addConstr(7 * x0 + 9 * x2 <= 272)
m.addConstr(9 * x2 + 1 * x3 <= 146)
m.addConstr(14 * x1 + 1 * x3 <= 222)
m.addConstr(7 * x0 + 14 * x1 + 9 * x2 + 1 * x3 <= 222)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Laura: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Bill: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
else:
    print("The model is infeasible")
