
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")
    potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
    cherry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
    bowls_of_cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")

    # Set objective function
    m.setObjective(1.55 * chicken_breasts + 1.56 * potatoes + 1.55 * cherry_pies + 2.54 * bowls_of_cereal, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7 * chicken_breasts + 19 * cherry_pies >= 49)
    m.addConstr(1 * potatoes + 19 * cherry_pies >= 51)
    m.addConstr(1 * potatoes + 7 * bowls_of_cereal >= 22)
    m.addConstr(19 * cherry_pies + 7 * bowls_of_cereal >= 18)
    m.addConstr(7 * chicken_breasts + 1 * potatoes >= 35)
    m.addConstr(7 * chicken_breasts + 1 * potatoes + 19 * cherry_pies >= 31)
    m.addConstr(7 * chicken_breasts + 1 * potatoes + 19 * cherry_pies + 7 * bowls_of_cereal >= 31)
    m.addConstr(7 * chicken_breasts - 9 * cherry_pies >= 0)
    m.addConstr(5 * potatoes - 5 * bowls_of_cereal >= 0)
    m.addConstr(7 * chicken_breasts + 1 * potatoes <= 135)
    m.addConstr(1 * potatoes + 7 * bowls_of_cereal <= 53)
    m.addConstr(7 * chicken_breasts + 7 * bowls_of_cereal <= 174)
    m.addConstr(1 * potatoes + 19 * cherry_pies + 7 * bowls_of_cereal <= 147)
    m.addConstr(7 * chicken_breasts + 1 * potatoes + 19 * cherry_pies + 7 * bowls_of_cereal <= 209)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
