
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="chicken_breasts", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="potatoes", lb=0)     # No lower bound specified, assuming 0
    x3 = model.addVar(name="cherry_pies", lb=0)  # No lower bound specified, assuming 0
    x4 = model.addVar(name="bowls_of_cereal", lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(1.55*x1 + 1.56*x2 + 1.55*x3 + 2.54*x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(7*x1 + 19*x3 >= 49)
    model.addConstr(x2 + 19*x3 >= 51)
    model.addConstr(x2 + 7*x4 >= 22)
    model.addConstr(19*x3 + 7*x4 >= 18)
    model.addConstr(7*x1 + x2 >= 35)
    model.addConstr(7*x1 + x2 + 19*x3 >= 31)
    model.addConstr(7*x1 + x2 + 19*x3 + 7*x4 >= 31)
    model.addConstr(7*x1 - 9*x3 >= 0)
    model.addConstr(5*x2 - 5*x4 >= 0)
    model.addConstr(7*x1 + x2 <= 135)
    model.addConstr(x2 + 7*x4 <= 53)
    model.addConstr(7*x1 + 7*x4 <= 174)
    model.addConstr(x2 + 19*x3 + 7*x4 <= 147)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("Chicken breasts: ", x1.varValue)
        print("Potatoes: ", x2.varValue)
        print("Cherry pies: ", x3.varValue)
        print("Bowls of cereal: ", x4.varValue)
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_problem()
