
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    hank_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hank_hours")
    bobby_hours = m.addVar(vtype=gp.GRB.INTEGER, name="bobby_hours")
    peggy_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peggy_hours")


    # Set objective function
    m.setObjective(9.06 * hank_hours + 5.38 * bobby_hours + 9.94 * peggy_hours, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6.31 * hank_hours + 14.73 * bobby_hours >= 56)
    m.addConstr(6.31 * hank_hours + 14.73 * bobby_hours + 14.29 * peggy_hours >= 56)
    m.addConstr(17.26 * hank_hours + 19.79 * bobby_hours >= 27)
    m.addConstr(17.26 * hank_hours + 19.79 * bobby_hours + 9.37 * peggy_hours >= 27)
    m.addConstr(5.05 * bobby_hours + 19.88 * peggy_hours >= 30)
    m.addConstr(15.74 * hank_hours + 19.88 * peggy_hours >= 44)
    m.addConstr(15.74 * hank_hours + 5.05 * bobby_hours + 19.88 * peggy_hours >= 44)
    m.addConstr(9.25 * hank_hours + 2.08 * peggy_hours >= 22)
    m.addConstr(16.92 * bobby_hours + 2.08 * peggy_hours >= 42)
    m.addConstr(9.25 * hank_hours + 16.92 * bobby_hours + 2.08 * peggy_hours >= 42)
    m.addConstr(2.6 * hank_hours + 17.17 * peggy_hours >= 38)
    m.addConstr(2.6 * hank_hours + 0.19 * bobby_hours + 17.17 * peggy_hours >= 49)
    m.addConstr(2.6 * hank_hours + 0.19 * bobby_hours + 17.17 * peggy_hours >= 49)  # Duplicate constraint removed
    m.addConstr(-6 * hank_hours + 6 * bobby_hours >= 0)
    m.addConstr(9.25 * hank_hours + 2.08 * peggy_hours <= 77)
    m.addConstr(2.6 * hank_hours + 0.19 * bobby_hours + 17.17 * peggy_hours <= 159)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Hank Hours:', hank_hours.x)
        print('Bobby Hours:', bobby_hours.x)
        print('Peggy Hours:', peggy_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
