
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(lb=0, name="hours_worked_by_Hank", vtype=gp.GRB.CONTINUOUS)
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_Bobby")
x2 = m.addVar(lb=0, name="hours_worked_by_Peggy", vtype=gp.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(9.06 * x0 + 5.38 * x1 + 9.94 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6.31 * x0 + 14.73 * x1 >= 56, name="work_quality_rating_Hank_Bobby")
m.addConstr(6.31 * x0 + 14.73 * x1 + 14.29 * x2 >= 56, name="work_quality_rating_all")
m.addConstr(17.26 * x0 + 19.79 * x1 >= 27, name="likelihood_to_quit_index_Hank_Bobby")
m.addConstr(17.26 * x0 + 19.79 * x1 + 9.37 * x2 >= 27, name="likelihood_to_quit_index_all")
m.addConstr(5.05 * x1 + 19.88 * x2 >= 30, name="dollar_cost_per_hour_Bobby_Peggy")
m.addConstr(15.74 * x0 + 19.88 * x2 >= 44, name="dollar_cost_per_hour_Hank_Peggy")
m.addConstr(15.74 * x0 + 5.05 * x1 + 19.88 * x2 >= 44, name="dollar_cost_per_hour_all")
m.addConstr(9.25 * x0 + 2.08 * x2 >= 22, name="organization_score_Hank_Peggy")
m.addConstr(16.92 * x1 + 2.08 * x2 >= 42, name="organization_score_Bobby_Peggy")
m.addConstr(9.25 * x0 + 16.92 * x1 + 2.08 * x2 >= 42, name="organization_score_all")
m.addConstr(2.6 * x0 + 17.17 * x2 >= 38, name="productivity_rating_Hank_Peggy")
m.addConstr(2.6 * x0 + 0.19 * x1 + 17.17 * x2 >= 49, name="productivity_rating_all")
m.addConstr(-6 * x0 + 6 * x1 >= 0, name="Hank_Bobby_work_balance")
m.addConstr(9.25 * x0 + 2.08 * x2 <= 77, name="organization_score_limit")
m.addConstr(2.6 * x0 + 0.19 * x1 + 17.17 * x2 <= 159, name="productivity_rating_limit")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x0.varValue)
    print("Hours worked by Bobby: ", x1.varValue)
    print("Hours worked by Peggy: ", x2.varValue)
else:
    print("The model is infeasible")
