
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(lb=0, name="x0")  # milligrams of vitamin B1
x1 = m.addVar(lb=0, name="x1")  # milligrams of vitamin D
x2 = m.addVar(lb=0, name="x2")  # milligrams of zinc
x3 = m.addVar(lb=0, name="x3")  # milligrams of vitamin B9
x4 = m.addVar(lb=0, name="x4")  # milligrams of vitamin B7

# Define the objective function
m.setObjective(3.57*x0 + 7.75*x1 + 7.95*x2 + 8.59*x3 + 9.65*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x0 <= 166)
m.addConstr(7*x0 <= 164)
m.addConstr(4*x0 <= 351)
m.addConstr(8*x1 <= 166)
m.addConstr(10*x1 <= 164)
m.addConstr(1*x1 <= 351)
m.addConstr(10*x2 <= 166)
m.addConstr(9*x2 <= 164)
m.addConstr(6*x2 <= 351)
m.addConstr(10*x3 <= 166)
m.addConstr(3*x3 <= 164)
m.addConstr(9*x3 <= 351)
m.addConstr(13*x4 <= 166)
m.addConstr(8*x4 <= 164)
m.addConstr(5*x4 <= 351)
m.addConstr(9*x2 + 8*x4 >= 19)
m.addConstr(9*x2 + 3*x3 >= 30)
m.addConstr(3*x3 + 8*x4 >= 27)
m.addConstr(10*x1 + 3*x3 >= 32)
m.addConstr(7*x0 + 8*x4 >= 13)
m.addConstr(10*x1 + 8*x4 >= 10)
m.addConstr(10*x1 + 9*x2 + 3*x3 >= 16)
m.addConstr(9*x3 + 5*x4 >= 43)
m.addConstr(4*x0 + 9*x3 >= 48)
m.addConstr(6*x2 + 9*x3 >= 34)
m.addConstr(6*x2 + 5*x4 >= 62)
m.addConstr(1*x1 + 6*x2 >= 46)
m.addConstr(4*x0 + 6*x2 + 5*x4 >= 37)
m.addConstr(4*x0 + 1*x1 + 9*x3 >= 37)
m.addConstr(4*x0 + 6*x2 + 5*x4 >= 45)
m.addConstr(4*x0 + 1*x1 + 9*x3 >= 45)
m.addConstr(1*x0 + 10*x2 <= 133)
m.addConstr(10*x2 + 10*x3 <= 41)
m.addConstr(1*x1 + 10*x2 <= 94)
m.addConstr(1*x1 + 13*x4 <= 86)
m.addConstr(10*x3 + 13*x4 <= 131)
m.addConstr(1*x0 + 1*x1 + 10*x2 + 10*x3 + 13*x4 <= 131)
m.addConstr(7*x0 + 3*x3 <= 102)
m.addConstr(7*x0 + 10*x1 <= 60)
m.addConstr(9*x2 + 8*x4 <= 104)
m.addConstr(7*x0 + 8*x4 <= 105)
m.addConstr(10*x1 + 3*x3 <= 114)
m.addConstr(1*x1 + 9*x2 <= 142)
m.addConstr(7*x0 + 9*x2 <= 52)
m.addConstr(3*x3 + 8*x4 <= 124)
m.addConstr(7*x0 + 10*x1 + 9*x2 + 3*x3 + 8*x4 <= 124)
m.addConstr(6*x2 + 5*x4 <= 232)
m.addConstr(4*x0 + 5*x4 <= 139)
m.addConstr(1*x1 + 6*x2 <= 200)
m.addConstr(4*x0 + 9*x3 <= 83)
m.addConstr(4*x0 + 6*x2 <= 260)
m.addConstr(4*x0 + 1*x1 <= 349)
m.addConstr(4*x0 + 1*x1 + 6*x2 + 9*x3 + 5*x4 <= 349)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("milligrams of vitamin B1: ", x0.varValue)
    print("milligrams of vitamin D: ", x1.varValue)
    print("milligrams of zinc: ", x2.varValue)
    print("milligrams of vitamin B9: ", x3.varValue)
    print("milligrams of vitamin B7: ", x4.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
