
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="grams_of_fat", lb=0)  # Non-negative
    x1 = m.addVar(name="milligrams_of_vitamin_C", lb=0)  # Non-negative


    # Set objective function
    m.setObjective(8 * x0 + 4 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14 * x0 + 12 * x1 >= 21, "digestive_support_lower")
    m.addConstr(7 * x0 + 15 * x1 >= 38, "cognitive_performance_lower")
    m.addConstr(-1 * x0 + 6 * x1 >= 0, "constraint_3")
    m.addConstr(14 * x0 + 12 * x1 <= 71, "digestive_support_upper")
    m.addConstr(7 * x0 + 15 * x1 <= 88, "cognitive_performance_upper")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"grams of fat: {x0.x}")
        print(f"milligrams of vitamin C: {x1.x}")
        print(f"Objective Value: {m.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized correctly.")

