
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fat")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Set the objective function
m.setObjective(8*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(14*x1 + 12*x2 >= 21, "digestive_support_index")
m.addConstr(7*x1 + 15*x2 >= 38, "cognitive_performance_index")
m.addConstr(-x1 + 6*x2 >= 0, "linear_inequality")
m.addConstr(14*x1 + 12*x2 <= 71, "max_digestive_support")
m.addConstr(7*x1 + 15*x2 <= 88, "max_cognitive_performance")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of fat: {x1.x}")
    print(f"Milligrams of vitamin C: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
