
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="grams_of_fat", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams_of_vitamin_C", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(8 * x1 + 4 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14 * x1 + 12 * x2 >= 21, name="digestive_support_index_min")
    model.addConstr(7 * x1 + 15 * x2 >= 38, name="cognitive_performance_index_min")
    model.addConstr(-x1 + 6 * x2 >= 0, name="fat_vitamin_C_relation")
    model.addConstr(14 * x1 + 12 * x2 <= 71, name="digestive_support_index_max")
    model.addConstr(7 * x1 + 15 * x2 <= 88, name="cognitive_performance_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of fat: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
