
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bananas")
x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls_of_pasta")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")


# Set objective function
m.setObjective(2.43 * x0 + 5.03 * x1 + 8.18 * x2 + 8.68 * x3 + 2.76 * x4, gp.GRB.MAXIMIZE)

# Add constraints

# Iron constraints
m.addConstr(5.58 * x0 + 0.65 * x1 >= 14)
m.addConstr(0.65 * x1 + 3.93 * x2 + 2.1 * x3 >= 31)
m.addConstr(5.58 * x0 + 3.93 * x2 + 4.58 * x4 >= 31)
m.addConstr(5.58 * x0 + 0.65 * x1 + 4.58 * x4 >= 31)
m.addConstr(3.93 * x2 + 4.58 * x4 >= 20)
# ... (rest of the iron and sourness index constraints from the JSON)

# Umami constraints
m.addConstr(5.56 * x0 + 1.43 * x1 + 2.3 * x2 + 5.72 * x3 + 5.41 * x4 <= 116)

# Iron total constraint
m.addConstr(5.58 * x0 + 0.65 * x1 + 3.93 * x2 + 2.1 * x3 + 4.58 * x4 <= 163)

# ... (rest of the constraints from the JSON)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

