
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    hank = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank")
    mary = model.addVar(lb=0, vtype=GRB.INTEGER, name="mary")
    ringo = model.addVar(lb=0, vtype=GRB.INTEGER, name="ringo")
    john = model.addVar(lb=0, vtype=GRB.INTEGER, name="john")

    # Set objective function
    model.setObjective(8*hank**2 + 5*hank*ringo + 7*hank*john + 5*mary**2 + 4*ringo**2 + 4*john**2 + 3*hank + 6*john, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13*hank + 12*ringo + 1*john >= 77)
    model.addConstr(20*mary + 1*john <= 156)
    model.addConstr(16*hank**2 + 20*mary**2 <= 326)
    model.addConstr(16*hank + 16*ringo <= 404)
    model.addConstr(16*hank**2 + 1*john**2 <= 213)
    model.addConstr(16*ringo + 1*john <= 146)
    model.addConstr(16*hank**2 + 20*mary**2 + 1*john**2 <= 353)
    model.addConstr(16*hank + 20*mary + 16*ringo + 1*john <= 353)
    model.addConstr(4*mary + 12*ringo <= 314)
    model.addConstr(4*mary + 1*john <= 119)
    model.addConstr(13*hank**2 + 1*john**2 <= 97)
    model.addConstr(13*hank**2 + 12*ringo**2 <= 218)
    model.addConstr(13*hank + 4*mary <= 301)
    model.addConstr(13*hank + 4*mary + 12*ringo + 1*john <= 301)


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('hank:', hank.x)
        print('mary:', mary.x)
        print('ringo:', ringo.x)
        print('john:', john.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
