
import gurobi

# Define the model
model = gurobi.Model()

# Define variables
x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")  # hours worked by Hank
x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # hours worked by Mary
x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="x2", vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
x3 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by John

# Objective function
model.setObjective(8*x0**2 + 5*x0*x2 + 7*x0*x3 + 5*x1**2 + 4*x2**2 + 4*x3**2 + 3*x0 + 6*x3, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(16*x0 <= 432)
model.addConstr(13*x0 <= 335)
model.addConstr(20*x1 <= 432)
model.addConstr(4*x1 <= 335)
model.addConstr(16*x2 <= 432)
model.addConstr(12*x2 <= 335)
model.addConstr(x3 <= 432)
model.addConstr(x3 <= 335)
model.addConstr(13*x0 + 12*x2 + x3 >= 77)
model.addConstr(20*x1 + x3 <= 156)
model.addConstr(16*x0**2 + 20*x1**2 <= 326)
model.addConstr(16*x0 + 16*x2 <= 404)
model.addConstr(16*x0**2 + x3**2 <= 213)
model.addConstr(16*x2 + x3 <= 146)
model.addConstr(16*x0**2 + 20*x1**2 + x3**2 <= 353)
model.addConstr(16*x0 + 20*x1 + 16*x2 + x3 <= 353)
model.addConstr(4*x1 + 12*x2 <= 314)
model.addConstr(4*x1 + x3 <= 119)
model.addConstr(13*x0**2 + x3**2 <= 97)
model.addConstr(13*x0**2 + 12*x2**2 <= 218)
model.addConstr(13*x0 + 4*x1 <= 301)
model.addConstr(13*x0 + 4*x1 + 12*x2 + x3 <= 301)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
