
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="fruit_salads")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="sashimi")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bowls_of_instant_ramen")


# Set objective function
m.setObjective(1.17*x0**2 + 6.23*x0*x1 + 3.65*x0*x2 + 3.75*x1**2 + 1.87*x1*x2 + 6.35*x0 + 8.12*x1 + 2.37*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6.94*x0 + 3.98*x1 + 7.82*x2 <= 133, "fat_constraint")
m.addConstr(5.74*x0 + 6.87*x1 + 1.66*x2 <= 182, "iron_constraint")
m.addConstr(3.98*x1 + 7.82*x2 >= 27, "sashimi_ramen_fat")
m.addConstr(6.94*x0 + 7.82*x2 >= 44, "fruit_ramen_fat")
m.addConstr(6.94*x0 + 3.98*x1 + 7.82*x2 >= 44, "total_fat")
m.addConstr(5.74*x0 + 1.66*x2 >= 20, "fruit_ramen_iron")
m.addConstr(5.74*x0 + 6.87*x1 + 1.66*x2 >= 40, "total_iron")
m.addConstr(5.74*x0 + 6.87*x1 + 1.66*x2 >= 40, "total_iron2") # Duplicate constraint from input
m.addConstr(-10*x1 + 7*x2 >= 0, "sashimi_ramen_relation")
m.addConstr(-x0 + 5*x1 >= 0, "fruit_sashimi_relation")
m.addConstr(6.94*x0**2 + 3.98*x1**2 + 7.82*x2**2 <= 65, "squared_fat")
m.addConstr(5.74*x0**2 + 6.87*x1**2 + 1.66*x2**2 <= 122, "squared_iron")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('fruit_salads:', x0.x)
    print('sashimi:', x1.x)
    print('bowls_of_instant_ramen:', x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

