
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="fruit_salads", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="sashimi", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="bowls_of_instant_ramen", vtype=gurobi.GRB.CONTINUOUS)

# Objective function
m.setObjective(1.17*x0**2 + 6.23*x0*x1 + 3.65*x0*x2 + 3.75*x1**2 + 1.87*x1*x2 + 6.35*x0 + 8.12*x1 + 2.37*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(6.94*x0 + 3.98*x1 + 7.82*x2 <= 133)
m.addConstr(5.74*x0 + 6.87*x1 + 1.66*x2 <= 182)
m.addConstr(3.98*x1 + 7.82*x2 >= 27)
m.addConstr(6.94*x0 + 7.82*x2 >= 44)
m.addConstr(6.94*x0 + 3.98*x1 + 7.82*x2 >= 44)
m.addConstr(5.74*x0 + 1.66*x2 >= 20)
m.addConstr(5.74*x0 + 6.87*x1 + 1.66*x2 >= 40)
m.addConstr(-10*x1 + 7*x2 >= 0)
m.addConstr(-x0 + 5*x1 >= 0)
m.addConstr(6.94**2*x0**2 + 3.98**2*x1**2 + 7.82**2*x2**2 <= 65)
m.addConstr(5.74**2*x0**2 + 6.87**2*x1**2 + 1.66**2*x2**2 <= 122)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Fruit Salads: ", x0.varValue)
    print("Sashimi: ", x1.varValue)
    print("Bowls of Instant Ramen: ", x2.varValue)
else:
    print("The model is infeasible")
