
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B6
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1")  # milligrams of vitamin B2
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of calcium


# Set objective function
m.setObjective(3.09*x0**2 + 8.41*x0*x2 + 2.01*x2**2 + 8.39*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16*x0 <= 201, "c0")
m.addConstr(20*x1 <= 201, "c1")
m.addConstr(22*x2 <= 201, "c2")
m.addConstr(20*x1 + 22*x2 >= 52, "c3")
m.addConstr(16*x0 + 20*x1 + 22*x2 >= 52, "c4")
m.addConstr(16*x0 + 22*x2 <= 101, "c5")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
    print('x2: %g' % x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

