
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B6")
x2 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B2")  # Must be a whole number
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_calcium")

# Objective function
m.setObjective(3.09 * x1**2 + 8.41 * x1 * x3 + 2.01 * x3**2 + 8.39 * x3, GRB.MINIMIZE)

# Constraints
m.addConstr(x1 == 16)
m.addConstr(x2 == 20)
m.addConstr(20*x2 + 22*x3 >= 52)
m.addConstr(16*x1 + 20*x2 + 22*x3 >= 52)
m.addConstr(16*x1 + 22*x3 <= 101)

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)
