
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="x3", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.CONTINUOUS)
    
    # Objective function
    model.setObjective(3.09*x1**2 + 8.41*x1*x3 + 2.01*x3**2 + 8.39*x3, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(20*x2 + 22*x3 >= 52, name="constraint_1")
    model.addConstr(16*x1 + 20*x2 + 22*x3 >= 52, name="constraint_2")
    model.addConstr(16*x1 + 22*x3 <= 101, name="constraint_3")
    
    # Solve the problem
    model.optimize()
    
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The problem has no optimal solution.")

optimize_problem()
