
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Cost")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Paul")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Ringo")


    # Set objective function
    model.setObjective(4*x0 + 6*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9*x0 + 2*x1 >= 20, "dollar_cost_lower")
    model.addConstr(6*x0 + 7*x1 >= 19, "paperwork_lower")
    model.addConstr(5*x0 + 1*x1 >= 22, "work_quality_lower")
    model.addConstr(10*x0 + 7*x1 >= 16, "organization_lower")
    model.addConstr(3*x0 - 3*x1 >= 0, "custom_constraint")

    model.addConstr(9*x0 + 2*x1 <= 24, "dollar_cost_upper")
    model.addConstr(6*x0 + 7*x1 <= 32, "paperwork_upper")
    model.addConstr(5*x0 + 1*x1 <= 35, "work_quality_upper")
    model.addConstr(10*x0 + 7*x1 <= 37, "organization_upper")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Paul: {x0.x}")
        print(f"Hours worked by Ringo: {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
