
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Paul
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Ringo

    # Objective function: minimize 4*x1 + 6*x2
    model.setObjective(4 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9 * x1 + 2 * x2 >= 20)
    model.addConstr(6 * x1 + 7 * x2 >= 19)
    model.addConstr(5 * x1 + x2 >= 22)
    model.addConstr(10 * x1 + 7 * x2 >= 16)
    model.addConstr(3 * x1 - 3 * x2 >= 0)
    model.addConstr(9 * x1 + 2 * x2 <= 24)
    model.addConstr(6 * x1 + 7 * x2 <= 32)
    model.addConstr(5 * x1 + x2 <= 35)
    model.addConstr(10 * x1 + 7 * x2 <= 37)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Paul: ", x1.varValue)
        print("Hours worked by Ringo: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
