
from gurobipy import Model, GRB

# Create a new model
model = Model("Employee_Scheduling")

# Create variables
peggy = model.addVar(vtype=GRB.INTEGER, name="peggy")
mary = model.addVar(vtype=GRB.INTEGER, name="mary")
john = model.addVar(vtype=GRB.INTEGER, name="john")
laura = model.addVar(vtype=GRB.INTEGER, name="laura")
bobby = model.addVar(vtype=GRB.INTEGER, name="bobby")
george = model.addVar(vtype=GRB.INTEGER, name="george")
bill = model.addVar(vtype=GRB.INTEGER, name="bill")


# Set objective function
model.setObjective(2 * peggy + 1 * mary + 5 * john + 9 * laura + 4 * bobby + 9 * george + 8 * bill, GRB.MAXIMIZE)

# Add constraints

model.addConstr(8*peggy + 9*bill >= 68)
model.addConstr(8*laura + 4*bobby >= 55)
model.addConstr(8*laura + 1*george >= 58)
model.addConstr(8*peggy + 7*john >= 41)
model.addConstr(3*mary + 7*john >= 43)
model.addConstr(7*john + 1*george >= 40)
model.addConstr(8*peggy + 4*bobby >= 33)
model.addConstr(3*mary + 1*george >= 37)
model.addConstr(8*peggy + 8*laura >= 45)
model.addConstr(7*john + 8*laura >= 38)
model.addConstr(8*laura + 4*bobby + 9*bill >= 52)
model.addConstr(8*peggy + 3*mary + 4*bobby >= 52)
model.addConstr(7*john + 1*george + 9*bill >= 52)
model.addConstr(8*peggy + 7*john + 1*george >= 52)
model.addConstr(4*bobby + 1*george + 9*bill >= 52)
model.addConstr(9*laura + 6*bill >= 26)
model.addConstr(2*john + 10*bobby >= 52)
model.addConstr(3*mary + 5*george + 6*bill >= 41)
model.addConstr(9*mary + 2*bill >= 32)
model.addConstr(4*george + 2*bill >= 29)
model.addConstr(9*mary + 8*john >= 40)
model.addConstr(5*peggy + 1*bobby >= 19)
model.addConstr(9*mary + 1*bobby >= 35)
model.addConstr(8*john + 1*bobby >= 39)
model.addConstr(7*laura + 4*george >= 27)
model.addConstr(7*laura + 2*bill >= 31)


#Resource Constraints
r = {}
r[0] = {'ub': 476, 'peggy': 8, 'mary': 3, 'john': 7, 'laura': 8, 'bobby': 4, 'george': 1, 'bill': 9}
r[1] = {'ub': 474, 'peggy': 11, 'mary': 3, 'john': 2, 'laura': 9, 'bobby': 10, 'george': 5, 'bill': 6}
r[2] = {'ub': 290, 'peggy': 5, 'mary': 9, 'john': 8, 'laura': 7, 'bobby': 1, 'george': 4, 'bill': 2}
r[3] = {'ub': 521, 'peggy': 7, 'mary': 9, 'john': 6, 'laura': 3, 'bobby': 10, 'george': 2, 'bill': 4}

for i in range(4):
    model.addConstr(r[i]['peggy']*peggy + r[i]['mary']*mary + r[i]['john']*john + r[i]['laura']*laura + r[i]['bobby']*bobby + r[i]['george']*george + r[i]['bill']*bill <= r[i]['ub'])


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Objective value:", model.objVal)
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

