
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cantaloupes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")
chicken_breasts = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")

# Set objective function
m.setObjective(6*cantaloupes + 2*apples + 2*kiwis + 8*chicken_breasts, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*cantaloupes + 16*apples + 9*kiwis + 19*chicken_breasts <= 220, "calcium_upper_bound")
m.addConstr(18*cantaloupes + 18*apples + 18*kiwis + 23*chicken_breasts <= 87, "sourness_upper_bound")
m.addConstr(3*cantaloupes + 9*apples + 20*kiwis + 5*chicken_breasts <= 290, "cost_upper_bound")

m.addConstr(20*cantaloupes + 16*apples + 9*kiwis >= 31, "calcium_lower_bound")
m.addConstr(3*cantaloupes + 9*apples >= 33, "cantaloupes_apples_cost_lower_bound")

m.addConstr(16*apples + 9*kiwis <= 146, "apples_kiwis_calcium_upper_bound")
m.addConstr(20*cantaloupes + 9*kiwis <= 156, "cantaloupes_kiwis_calcium_upper_bound")
m.addConstr(9*kiwis + 19*chicken_breasts <= 150, "kiwis_chicken_calcium_upper_bound")
m.addConstr(20*cantaloupes + 16*apples + 9*kiwis + 19*chicken_breasts <= 150, "total_calcium_upper_bound")


m.addConstr(18*cantaloupes + 18*apples <= 78, "cantaloupes_apples_sourness_upper_bound")
m.addConstr(18*cantaloupes + 23*chicken_breasts <= 80, "cantaloupes_chicken_sourness_upper_bound")
m.addConstr(18*cantaloupes + 18*apples + 18*kiwis <= 65, "cantaloupes_apples_kiwis_sourness_upper_bound")
m.addConstr(18*apples + 18*kiwis + 23*chicken_breasts <= 43, "apples_kiwis_chicken_sourness_upper_bound")
m.addConstr(18*cantaloupes + 18*kiwis + 23*chicken_breasts <= 34, "cantaloupes_kiwis_chicken_sourness_upper_bound_2")
m.addConstr(18*cantaloupes + 18*apples + 18*kiwis + 23*chicken_breasts <= 34, "total_sourness_upper_bound")

m.addConstr(3*cantaloupes + 9*apples <= 224, "cantaloupes_apples_cost_upper_bound")
m.addConstr(9*apples + 5*chicken_breasts <= 274, "apples_chicken_cost_upper_bound")
m.addConstr(3*cantaloupes + 20*kiwis + 5*chicken_breasts <= 237, "cantaloupes_kiwis_chicken_cost_upper_bound")
m.addConstr(3*cantaloupes + 9*apples + 20*kiwis + 5*chicken_breasts <= 237, "total_cost_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

