
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="cantaloupes", lb=0)
x2 = model.addVar(name="apples", lb=0)
x3 = model.addVar(name="kiwis", lb=0)
x4 = model.addVar(name="chicken breasts", lb=0)

# Define the objective function
model.setObjective(6 * x1 + 2 * x2 + 2 * x3 + 8 * x4, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * x1 + 16 * x2 + 9 * x3 + 19 * x4 <= 220)
model.addConstr(18 * x1 + 18 * x2 + 18 * x3 + 23 * x4 <= 87)
model.addConstr(3 * x1 + 9 * x2 + 20 * x3 + 5 * x4 <= 290)
model.addConstr(20 * x1 + 16 * x2 + 9 * x3 >= 31)
model.addConstr(3 * x1 + 9 * x2 >= 33)
model.addConstr(16 * x2 + 9 * x3 <= 146)
model.addConstr(20 * x1 + 9 * x3 <= 156)
model.addConstr(9 * x3 + 19 * x4 <= 150)
model.addConstr(20 * x1 + 16 * x2 + 9 * x3 + 19 * x4 <= 150)
model.addConstr(18 * x1 + 18 * x2 <= 78)
model.addConstr(18 * x1 + 23 * x4 <= 80)
model.addConstr(18 * x1 + 18 * x2 + 18 * x3 <= 65)
model.addConstr(18 * x2 + 18 * x3 + 23 * x4 <= 43)
model.addConstr(18 * x1 + 18 * x3 + 23 * x4 <= 34)
model.addConstr(18 * x1 + 18 * x2 + 18 * x3 + 23 * x4 <= 34)
model.addConstr(3 * x1 + 9 * x2 <= 224)
model.addConstr(9 * x2 + 5 * x4 <= 274)
model.addConstr(3 * x1 + 20 * x3 + 5 * x4 <= 237)
model.addConstr(3 * x1 + 9 * x2 + 20 * x3 + 5 * x4 <= 237)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("cantaloupes: ", x1.varValue)
    print("apples: ", x2.varValue)
    print("kiwis: ", x3.varValue)
    print("chicken breasts: ", x4.varValue)
else:
    print("The model is infeasible")
