
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
dale = model.addVar(vtype=gp.GRB.INTEGER, name="Dale")
george = model.addVar(vtype=gp.GRB.INTEGER, name="George")
john = model.addVar(vtype=gp.GRB.CONTINUOUS, name="John")
bill = model.addVar(vtype=gp.GRB.INTEGER, name="Bill")
mary = model.addVar(vtype=gp.GRB.INTEGER, name="Mary")


# Set objective function
model.setObjective(2 * dale + 8 * george + 9 * john + 5 * bill + 6 * mary, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * dale + 8 * george + 6 * bill >= 13)
model.addConstr(8 * george + 16 * john + 9 * mary >= 13)
model.addConstr(3 * dale + 8 * george + 9 * mary >= 13)
model.addConstr(3 * dale + 16 * john + 9 * mary >= 13)
model.addConstr(3 * dale + 6 * bill + 9 * mary >= 13)
model.addConstr(3 * dale + 16 * john + 6 * bill >= 13)

# ... (rest of the work quality rating constraints from 12-15) ...

model.addConstr(5 * george + 5 * mary >= 67)
model.addConstr(12 * dale + 9 * bill >= 31)
model.addConstr(12 * dale + 5 * george + 17 * john >= 48)
model.addConstr(9 * george + 7 * john + 4 * bill >= 55)
model.addConstr(7 * dale + 2 * mary >= 12)

# ... (rest of the upper bound constraints) ...


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Dale:', dale.x)
    print('George:', george.x)
    print('John:', john.x)
    print('Bill:', bill.x)
    print('Mary:', mary.x)

elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

