
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # hours worked by George
    x2 = model.addVar(name="x2")  # hours worked by John
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
    x4 = model.addVar(name="x4", vtype=gurobi.GRB.INTEGER)  # hours worked by Mary

    # Objective function
    model.setObjective(2 * x0 + 8 * x1 + 9 * x2 + 5 * x3 + 6 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3 * x0 + 8 * x1 + 16 * x2 + 6 * x3 + 9 * x4 <= 86)
    model.addConstr(12 * x0 + 5 * x1 + 17 * x2 + 9 * x3 + 5 * x4 <= 457)
    model.addConstr(7 * x0 + 9 * x1 + 7 * x2 + 4 * x3 + 12 * x4 <= 357)
    model.addConstr(7 * x0 + 15 * x1 + 17 * x2 + 6 * x3 + 2 * x4 <= 137)

    model.addConstr(3 * x0 + 8 * x1 + 6 * x3 >= 13)
    model.addConstr(8 * x1 + 16 * x2 + 9 * x4 >= 13)
    model.addConstr(3 * x0 + 8 * x1 + 9 * x4 >= 13)
    model.addConstr(3 * x0 + 16 * x2 + 9 * x4 >= 13)
    model.addConstr(3 * x0 + 6 * x3 + 9 * x4 >= 13)
    model.addConstr(3 * x0 + 16 * x2 + 6 * x3 >= 13)

    model.addConstr(5 * x1 + 5 * x4 >= 67)
    model.addConstr(12 * x0 + 9 * x3 >= 31)
    model.addConstr(12 * x0 + 5 * x1 + 17 * x2 >= 48)
    model.addConstr(9 * x1 + 7 * x2 + 4 * x3 >= 55)
    model.addConstr(7 * x0 + 2 * x4 >= 12)

    model.addConstr(3 * x0 + 9 * x4 <= 72)
    model.addConstr(8 * x1 + 9 * x4 <= 38)
    model.addConstr(16 * x2 + 6 * x3 <= 20)
    model.addConstr(3 * x0 + 16 * x2 + 9 * x4 <= 23)

    model.addConstr(17 * x2 + 9 * x3 <= 208)
    model.addConstr(12 * x0 + 5 * x1 <= 323)
    model.addConstr(17 * x2 + 5 * x4 <= 128)
    model.addConstr(5 * x1 + 17 * x2 <= 119)
    model.addConstr(12 * x0 + 17 * x2 <= 232)

    model.addConstr(9 * x1 + 4 * x3 <= 272)
    model.addConstr(9 * x1 + 7 * x2 + 12 * x4 <= 230)
    model.addConstr(7 * x2 + 4 * x3 + 12 * x4 <= 252)
    model.addConstr(7 * x0 + 9 * x1 + 7 * x2 <= 86)
    model.addConstr(7 * x0 + 9 * x1 + 4 * x3 <= 190)
    model.addConstr(7 * x0 + 7 * x2 + 12 * x4 <= 74)

    model.addConstr(7 * x0 + 6 * x3 <= 122)
    model.addConstr(7 * x0 + 17 * x2 <= 70)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
