
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("pizza_pie_optimization")

    # Create variables
    slices_of_pizza = m.addVar(vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")
    cherry_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cherry_pies")

    # Set objective function
    m.setObjective(6.19 * slices_of_pizza + 4.18 * cherry_pies, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5 * slices_of_pizza + 2 * cherry_pies >= 17, "fiber_min")
    m.addConstr(6 * slices_of_pizza + 6 * cherry_pies >= 36, "cost_min")
    m.addConstr(6 * slices_of_pizza + 1 * cherry_pies >= 9, "carbs_min")
    m.addConstr(5 * slices_of_pizza + 2 * cherry_pies >= 25, "tastiness_min")
    m.addConstr(-8 * slices_of_pizza + 4 * cherry_pies >= 0, "custom_constraint")
    
    m.addConstr(5 * slices_of_pizza + 2 * cherry_pies <= 44, "fiber_max")
    m.addConstr(6 * slices_of_pizza + 6 * cherry_pies <= 71, "cost_max")
    m.addConstr(6 * slices_of_pizza + 1 * cherry_pies <= 29, "carbs_max")
    m.addConstr(5 * slices_of_pizza + 2 * cherry_pies <= 62, "tastiness_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('slices_of_pizza:', slices_of_pizza.x)
        print('cherry_pies:', cherry_pies.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
