
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables to the model
x0 = model.addVar(vtype=GRB.CONTINUOUS, name="slices_of_pizza")
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="cherry_pies")

# Set the objective function
model.setObjective(6.19*x0 + 4.18*x1, GRB.MINIMIZE)

# Add constraints
model.addConstr(5*x0 + 2*x1 >= 17, "fiber_lower_bound")
model.addConstr(5*x0 + 2*x1 <= 44, "fiber_upper_bound")
model.addConstr(6*x0 + 6*x1 >= 36, "cost_lower_bound")
model.addConstr(6*x0 + 6*x1 <= 71, "cost_upper_bound")
model.addConstr(6*x0 + x1 >= 9, "carbohydrates_lower_bound")
model.addConstr(6*x0 + x1 <= 29, "carbohydrates_upper_bound")
model.addConstr(5*x0 + 2*x1 >= 25, "tastiness_rating_lower_bound")
model.addConstr(5*x0 + 2*x1 <= 62, "tastiness_rating_upper_bound")
model.addConstr(-8*x0 + 4*x1 >= 0, "additional_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("slices_of_pizza:", x0.x)
    print("cherry_pies:", x1.x)
    print("Objective function value:", model.objVal)
else:
    print("No optimal solution found.")
