
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="slices_of_pizza", lb=0)  # slices of pizza
    x2 = model.addVar(name="cherry_pies", lb=0)  # cherry pies

    # Objective function
    model.setObjective(6.19 * x1 + 4.18 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * x1 + 2 * x2 >= 17, name="fiber_min")
    model.addConstr(6 * x1 + 6 * x2 >= 36, name="cost_min")
    model.addConstr(6 * x1 + x2 >= 9, name="carbohydrates_min")
    model.addConstr(5 * x1 + 2 * x2 >= 25, name="tastiness_min")
    model.addConstr(-8 * x1 + 4 * x2 >= 0, name="other_constraint")
    model.addConstr(5 * x1 + 2 * x2 <= 44, name="fiber_max")
    model.addConstr(6 * x1 + 6 * x2 <= 71, name="cost_max")
    model.addConstr(6 * x1 + x2 <= 29, name="carbohydrates_max")
    model.addConstr(5 * x1 + 2 * x2 <= 62, name="tastiness_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Slices of pizza: {x1.varValue}")
        print(f"Cherry pies: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
