
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    hank = m.addVar(vtype=gp.GRB.INTEGER, name="hank")
    mary = m.addVar(vtype=gp.GRB.INTEGER, name="mary")
    dale = m.addVar(vtype=gp.GRB.INTEGER, name="dale")
    ringo = m.addVar(vtype=gp.GRB.INTEGER, name="ringo")

    # Set objective function
    m.setObjective(9.37 * hank + 3.17 * mary + 6.93 * dale + 5.9 * ringo, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11 * hank + 4 * ringo >= 11)
    m.addConstr(6 * mary + 4 * ringo >= 26)
    m.addConstr(11 * hank + 6 * mary >= 30)
    m.addConstr(6 * mary + 4 * dale >= 28)
    m.addConstr(11 * hank + 4 * dale >= 23)
    m.addConstr(4 * dale + 4 * ringo >= 17)
    m.addConstr(11 * hank + 6 * mary + 4 * dale + 4 * ringo >= 17)
    m.addConstr(8 * hank + 9 * ringo >= 20)
    m.addConstr(8 * hank + 8 * mary >= 13)
    m.addConstr(8 * mary + 6 * dale + 9 * ringo >= 17)
    m.addConstr(8 * hank + 8 * mary + 9 * ringo >= 17)
    m.addConstr(8 * mary + 6 * dale + 9 * ringo >= 11)
    m.addConstr(8 * hank + 8 * mary + 9 * ringo >= 11)
    m.addConstr(8 * hank + 8 * mary + 6 * dale + 9 * ringo >= 11)
    m.addConstr(6 * dale - 7 * ringo >= 0)
    m.addConstr(11 * hank + 6 * mary <= 77)
    m.addConstr(4 * dale + 4 * ringo <= 90)
    m.addConstr(6 * mary + 4 * ringo <= 82)
    m.addConstr(11 * hank + 6 * mary + 4 * dale <= 48)
    m.addConstr(11 * hank + 6 * mary + 4 * ringo <= 88)
    m.addConstr(8 * hank + 9 * ringo <= 28)
    m.addConstr(8 * mary + 9 * ringo <= 40)
    m.addConstr(8 * hank + 8 * mary + 6 * dale <= 63)
    m.addConstr(8 * hank + 8 * mary + 9 * ringo <= 21)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
