
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # hours worked by Hank
x1 = m.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
x2 = m.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by Dale
x3 = m.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo

# Define the objective function
m.setObjective(9.37 * x0 + 3.17 * x1 + 6.93 * x2 + 5.9 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(11 * x0 <= 136)
m.addConstr(8 * x0 <= 84)
m.addConstr(6 * x1 <= 136)
m.addConstr(8 * x1 <= 84)
m.addConstr(4 * x2 <= 136)
m.addConstr(6 * x2 <= 84)
m.addConstr(4 * x3 <= 136)
m.addConstr(9 * x3 <= 84)

m.addConstr(6 * x1 + 4 * x3 >= 26)
m.addConstr(11 * x0 + 4 * x3 >= 11)
m.addConstr(11 * x0 + 6 * x1 >= 30)
m.addConstr(6 * x1 + 4 * x2 >= 28)
m.addConstr(11 * x0 + 4 * x2 >= 23)
m.addConstr(4 * x2 + 4 * x3 >= 17)
m.addConstr(11 * x0 + 6 * x1 + 4 * x2 + 4 * x3 >= 17)

m.addConstr(8 * x0 + 9 * x3 >= 20)
m.addConstr(8 * x0 + 8 * x1 >= 13)
m.addConstr(8 * x1 + 6 * x2 + 9 * x3 >= 17)
m.addConstr(8 * x0 + 8 * x1 + 9 * x3 >= 17)
m.addConstr(8 * x1 + 6 * x2 + 9 * x3 >= 11)
m.addConstr(8 * x0 + 8 * x1 + 6 * x2 + 9 * x3 >= 11)

m.addConstr(6 * x2 - 7 * x3 >= 0)

m.addConstr(11 * x0 + 6 * x1 <= 77)
m.addConstr(4 * x2 + 4 * x3 <= 90)
m.addConstr(6 * x1 + 4 * x3 <= 82)
m.addConstr(11 * x0 + 6 * x1 + 4 * x2 <= 48)
m.addConstr(11 * x0 + 6 * x1 + 4 * x3 <= 88)

m.addConstr(8 * x0 + 9 * x3 <= 28)
m.addConstr(8 * x1 + 9 * x3 <= 40)
m.addConstr(8 * x0 + 8 * x1 + 6 * x2 <= 63)
m.addConstr(8 * x0 + 8 * x1 + 9 * x3 <= 21)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No solution found')
