
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of iron
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # milligrams of vitamin B3
    x2 = m.addVar(vtype=GRB.INTEGER, name="x2") # milligrams of vitamin B2


    # Set objective function
    m.setObjective(3*x0*x1 + 7*x0*x2 + 7*x2*x2 + 6*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 15*x1 + 13*x2 <= 90, "c0")
    m.addConstr(22*x0 + 6*x1 + 20*x2 <= 130, "c1")
    m.addConstr(22*x0*x0 + 20*x2*x2 >= 40, "c2")
    m.addConstr(6*x1 + 20*x2 >= 42, "c3")
    m.addConstr(15*x1 + 13*x2 <= 46, "c4")
    m.addConstr(6*x0*x0 + 15*x1*x1 <= 79, "c5")
    m.addConstr(6*x0 + 15*x1 + 13*x2 <= 79, "c6")
    m.addConstr(6*x1*x1 + 20*x2*x2 <= 79, "c7")
    m.addConstr(22*x0*x0 + 6*x1*x1 <= 126, "c8")
    m.addConstr(22*x0 + 6*x1 + 20*x2 <= 49, "c9")
    m.addConstr(22*x0 + 6*x1 + 20*x2 <= 49, "c10")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
