
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # milligrams of iron
x1 = model.addVar(name="x1")  # milligrams of vitamin B3
x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B2

# Objective function
model.setObjective(3*x0*x1 + 7*x0*x2 + 7*x2**2 + 6*x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(6*x0 <= 90)
model.addConstr(22*x0 <= 130)
model.addConstr(15*x1 <= 90)
model.addConstr(6*x1 <= 130)
model.addConstr(13*x2 <= 90)
model.addConstr(20*x2 <= 130)
model.addConstr(484*x0**2 + 400*x2**2 >= 40)
model.addConstr(6*x1 + 20*x2 >= 42)
model.addConstr(15*x1 + 13*x2 <= 46)
model.addConstr(36*x0**2 + 225*x1**2 <= 79)
model.addConstr(6*x0 + 15*x1 + 13*x2 <= 79)
model.addConstr(36*x1**2 + 400*x2**2 <= 79)
model.addConstr(484*x0**2 + 36*x1**2 <= 126)
model.addConstr(22*x0 + 6*x1 + 20*x2 <= 49)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of iron: {x0.varValue}")
    print(f"Milligrams of vitamin B3: {x1.varValue}")
    print(f"Milligrams of vitamin B2: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
