
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Laura
    x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1") # hours worked by Paul
    x2 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x2") # hours worked by Jean
    x3 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x3") # hours worked by Dale


    # Set objective function
    model.setObjective(5*x0 + 3*x1 + 5*x2 + 9*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*x0 + 5*x1 + 5*x2 + 11*x3 <= 89, "r0")
    model.addConstr(5*x2 + 11*x3 >= 22, "c1")
    model.addConstr(2*x0 + 11*x3 >= 13, "c2")
    model.addConstr(2*x0 + 5*x2 >= 17, "c3")
    model.addConstr(2*x0 + 5*x1 + 5*x2 >= 15, "c4")
    model.addConstr(5*x1 + 5*x2 <= 51, "c5")
    model.addConstr(2*x0 + 11*x3 <= 72, "c6")
    model.addConstr(2*x0 + 5*x1 <= 62, "c7")
    model.addConstr(2*x0 + 5*x1 + 5*x2 + 11*x3 <= 62, "c8")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        for v in model.getVars():
            print(f"{v.varName}: {v.x}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
