
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=0, name="hours_worked_by_Laura", vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(lb=0, name="hours_worked_by_Paul", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(lb=0, name="hours_worked_by_Jean", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(lb=0, name="hours_worked_by_Dale", vtype=gurobi.GRB.INTEGER)
    
    # Define objective function
    model.setObjective(5*x1 + 3*x2 + 5*x3 + 9*x4, gurobi.GRB.MAXIMIZE)
    
    # Define constraints
    model.addConstr(5*x3 + 11*x4 >= 22, name="constraint_1")
    model.addConstr(2*x1 + 11*x4 >= 13, name="constraint_2")
    model.addConstr(2*x1 + 5*x3 >= 17, name="constraint_3")
    model.addConstr(2*x1 + 5*x2 + 5*x3 >= 15, name="constraint_4")
    model.addConstr(5*x2 + 5*x3 <= 51, name="constraint_5")
    model.addConstr(2*x1 + 11*x4 <= 72, name="constraint_6")
    model.addConstr(2*x1 + 5*x2 <= 62, name="constraint_7")
    model.addConstr(2*x1 + 5*x2 + 5*x3 + 11*x4 <= 62, name="constraint_8")
    
    # Solve the model
    model.optimize()
    
    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Laura: ", x1.varValue)
        print("Hours worked by Paul: ", x2.varValue)
        print("Hours worked by Jean: ", x3.varValue)
        print("Hours worked by Dale: ", x4.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
