
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter sandwiches")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="steaks")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="strips of bacon")

# Set objective function
m.setObjective(1*x0 + 6*x1 + 8*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.0*x0 + 1.04*x2 >= 13, "calcium_constraint1")
m.addConstr(2.0*x0 + 0.96*x1 >= 12, "calcium_constraint2")
m.addConstr(2.0*x0 + 0.96*x1 + 1.04*x2 >= 12, "calcium_constraint3")
m.addConstr(-10*x1 + 1*x2 >= 0, "constraint4")
m.addConstr(-2*x0 + 7*x2 >= 0, "constraint5")
m.addConstr(2.0*x0 + 0.96*x1 + 1.04*x2 <= 32, "calcium_constraint6")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('peanutbutter sandwiches:', x0.x)
    print('steaks:', x1.x)
    print('strips of bacon:', x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

