
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="peanutbutter_sandwiches")
x2 = m.addVar(vtype=GRB.INTEGER, name="steaks")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="strips_of_bacon")

# Set the objective function
m.setObjective(1*x1 + 6*x2 + 8*x3, GRB.MINIMIZE)

# Add the constraints
m.addConstr(2.0*x1 + 1.04*x3 >= 13, "calcium_from_pb_and_bacon")
m.addConstr(2.0*x1 + 0.96*x2 >= 12, "calcium_from_pb_and_steaks")
m.addConstr(2.0*x1 + 0.96*x2 + 1.04*x3 >= 12, "total_calcium_lower_bound")
m.addConstr(-10*x2 + x3 >= 0, "steaks_and_bacon_constraint")
m.addConstr(-2*x1 + 7*x3 >= 0, "pb_and_bacon_constraint")
m.addConstr(2.0*x1 + 0.96*x2 + 1.04*x3 <= 32, "total_calcium_upper_bound")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"peanutbutter sandwiches: {x1.x}")
    print(f"steaks: {x2.x}")
    print(f"strips of bacon: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
