
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="steaks", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="strips_of_bacon")

    # Objective function
    model.setObjective(1*x1 + 6*x2 + 8*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2.0*x1 + 0.96*x2 + 1.04*x3 <= 70, name="calcium_upper_bound")
    model.addConstr(2.0*x1 + 1.04*x3 >= 13, name="calcium_from_sandwiches_and_bacon")
    model.addConstr(2.0*x1 + 0.96*x2 >= 12, name="calcium_from_sandwiches_and_steaks")
    model.addConstr(2.0*x1 + 0.96*x2 + 1.04*x3 >= 12, name="calcium_from_all")
    model.addConstr(-10*x2 + x3 >= 0, name="steaks_and_bacon_constraint")
    model.addConstr(-2*x1 + 7*x3 >= 0, name="sandwiches_and_bacon_constraint")
    model.addConstr(2.0*x1 + 0.96*x2 + 1.04*x3 <= 32, name="calcium_total_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Peanutbutter sandwiches: ", x1.varValue)
        print("Steaks: ", x2.varValue)
        print("Strips of bacon: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
