
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Work_Hours")

# Create variables
john_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
bobby_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")


# Set objective function
model.setObjective(3 * john_hours + 2 * bobby_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * john_hours + 8 * bobby_hours >= 7, "organization_score_min")
model.addConstr(5 * john_hours + 8 * bobby_hours <= 37, "organization_score_max")
model.addConstr(13 * john_hours + 1 * bobby_hours >= 8, "computer_competence_min")
model.addConstr(13 * john_hours + 1 * bobby_hours <= 16, "computer_competence_max")
model.addConstr(4 * john_hours - 8 * bobby_hours >= 0, "john_bobby_ratio")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: John's hours = {john_hours.x}, Bobby's hours = {bobby_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

