
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_John")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(3*x0 + 2*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x0 + 8*x1 >= 7, "organization_score_min")
m.addConstr(5*x0 + 8*x1 <= 37, "organization_score_max")
m.addConstr(13*x0 + x1 >= 8, "computer_competence_min")
m.addConstr(13*x0 + x1 <= 16, "computer_competence_max")
m.addConstr(4*x0 - 8*x1 >= 0, "additional_linear_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by John: {x0.x}")
    print(f"Hours worked by Bobby: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
