
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_John", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Bobby", lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(3*x1 + 2*x2, gurobi.MINIMIZE)

    # Add constraints
    model.addConstr(5*x1 + 8*x2 >= 7, name="org_score_min")
    model.addConstr(5*x1 + 8*x2 <= 47, name="org_score_max")
    model.addConstr(13*x1 + x2 >= 8, name="comp_comp_min")
    model.addConstr(13*x1 + x2 <= 29, name="comp_comp_max")
    model.addConstr(4*x1 - 8*x2 >= 0, name="hourly_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by John: {x1.varValue}")
        print(f"Hours worked by Bobby: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
