
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")


    # Set objective function
    m.setObjective(8.91 * vitamin_e + 4.08 * potassium + 6.4 * vitamin_a, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.06 * vitamin_e + 3.33 * potassium >= 36, "c1")
    m.addConstr(3.33 * potassium + 3.55 * vitamin_a >= 50, "c2")
    m.addConstr(0.65 * vitamin_e + 0.02 * potassium + 1.68 * vitamin_a >= 48, "c3")
    m.addConstr(3.33 * potassium + 3.55 * vitamin_a <= 113, "c4")
    m.addConstr(3.06 * vitamin_e + 3.33 * potassium <= 114, "c5")
    m.addConstr(3.06 * vitamin_e + 3.33 * potassium + 3.55 * vitamin_a <= 136, "c6")
    m.addConstr(0.65 * vitamin_e + 1.68 * vitamin_a <= 114, "c7")
    m.addConstr(0.65 * vitamin_e + 0.02 * potassium + 1.68 * vitamin_a <= 114, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_e:', vitamin_e.x)
        print('potassium:', potassium.x)
        print('vitamin_a:', vitamin_a.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
