
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='x0', lb=0)  # milligrams of vitamin E
x1 = model.addVar(name='x1', lb=0)  # milligrams of potassium
x2 = model.addVar(name='x2', lb=0)  # milligrams of vitamin A

# Define the objective function
model.setObjective(8.91 * x0 + 4.08 * x1 + 6.4 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3.06 * x0 + 3.33 * x1 >= 36)
model.addConstr(3.33 * x1 + 3.55 * x2 >= 50)
model.addConstr(0.65 * x0 + 0.02 * x1 + 1.68 * x2 >= 48)
model.addConstr(3.33 * x1 + 3.55 * x2 <= 113)
model.addConstr(3.06 * x0 + 3.33 * x1 <= 114)
model.addConstr(3.06 * x0 + 3.33 * x1 + 3.55 * x2 <= 136)
model.addConstr(0.65 * x0 + 1.68 * x2 <= 114)
model.addConstr(0.65 * x0 + 0.02 * x1 + 1.68 * x2 <= 114)

# Add resource constraints
r0_constraint = model.addConstr(3.06 * x0 + 3.33 * x1 + 3.55 * x2 <= 152)
r1_constraint = model.addConstr(0.65 * x0 + 0.02 * x1 + 1.68 * x2 <= 178)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('x0: ', x0.x)
    print('x1: ', x1.x)
    print('x2: ', x2.x)
else:
    print('The model is infeasible')
