
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean")
george = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george")
dale = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dale")


# Set objective function
m.setObjective(6.28*jean**2 + 4.64*dale**2 + 2.73*jean, GRB.MINIMIZE)

# Add constraints
m.addConstr(george**2 + dale**2 >= 42, "c0")
m.addConstr(7*jean + 1*george + 17*dale >= 42, "c1")
m.addConstr(16*jean + 10*george >= 49, "c2")
m.addConstr(16*jean + 10*george + 5*dale >= 49, "c3")
m.addConstr(-4*jean + 10*george >= 0, "c4")
m.addConstr(16*jean + 5*dale <= 125, "c5")
m.addConstr(10*george + 5*dale <= 143, "c6")



# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Jean:', jean.x)
    print('George:', george.x)
    print('Dale:', dale.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

