
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Jean
    x1 = model.addVar(name="x1", lb=0)  # hours worked by George
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Dale

    # Define the objective function
    model.setObjective(6.28 * x0**2 + 4.64 * x2**2 + 2.73 * x0, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x1**2 + x2**2 >= 42)
    model.addConstr(7 * x0 + x1 + 17 * x2 >= 42)
    model.addConstr(16 * x0 + 10 * x1 >= 49)
    model.addConstr(16 * x0 + 10 * x1 + 5 * x2 >= 49)
    model.addConstr(-4 * x0 + 10 * x1 >= 0)
    model.addConstr(16 * x0 + 5 * x2 <= 125)
    model.addConstr(10 * x1 + 5 * x2 <= 143)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Jean: ", x0.varValue)
        print("Hours worked by George: ", x1.varValue)
        print("Hours worked by Dale: ", x2.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
