
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams of potassium")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams of vitamin B5")


    # Set objective function
    m.setObjective(2.82*x0 + 7.0*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 13*x1 >= 82, "digestive_support_lower")
    m.addConstr(-5*x0 + x1 >= 0, "constraint_2")
    m.addConstr(6*x0 + 13*x1 <= 164, "digestive_support_upper")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("milligrams of potassium:", x0.x)
        print("milligrams of vitamin B5:", x1.x)


except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized correctly.")

