
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B5")

# Set the objective function
m.setObjective(2.82*x1 + 7.0*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 >= 82, "digestive_support_potassium")
m.addConstr(13*x2 >= 82, "digestive_support_vitamin_B5")
m.addConstr(6*x1 + 13*x2 >= 82, "total_digestive_support_min")
m.addConstr(-5*x1 + x2 >= 0, "potassium_vitamin_b5_ratio")
m.addConstr(6*x1 + 13*x2 <= 164, "total_digestive_support_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Potassium: {x1.x}")
    print(f"Milligrams of Vitamin B5: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
