
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_potassium", lb=0)  # Assuming lower bound is 0
    x2 = model.addVar(name="milligrams_of_vitamin_B5", lb=0)  # Assuming lower bound is 0

    # Objective function
    model.setObjective(2.82 * x1 + 7.0 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(6 * x1 + 13 * x2 >= 82, name="digestive_support_index_min")
    model.addConstr(-5 * x1 + x2 >= 0, name="vitamin_constraint")
    model.addConstr(6 * x1 + 13 * x2 <= 164, name="digestive_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of potassium: {x1.varValue}")
        print(f"Milligrams of vitamin B5: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
