
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B9
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # grams of fat
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # milligrams of vitamin D
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")  # milligrams of vitamin B3


# Set objective function
m.setObjective(7.01 * x0 + 5.53 * x1 + 5.94 * x2 + 6.61 * x3, gp.GRB.MINIMIZE)

# Add constraints
resources = {
    'r0': {'upper_bound': 84, 'x0': 0.74, 'x1': 2.63, 'x2': 1.99, 'x3': 1.7},
    'r1': {'upper_bound': 53, 'x0': 0.19, 'x1': 0.78, 'x2': 1.04, 'x3': 1.89},
    'r2': {'upper_bound': 111, 'x0': 0.37, 'x1': 3.07, 'x2': 0.64, 'x3': 2.01},
    'r3': {'upper_bound': 91, 'x0': 2.56, 'x1': 3.92, 'x2': 0.07, 'x3': 2.87},
    'r4': {'upper_bound': 93, 'x0': 0.72, 'x1': 1.16, 'x2': 3.15, 'x3': 2.24}
}

for r, data in resources.items():
    m.addConstr(data['x0'] * x0 + data['x1'] * x1 + data['x2'] * x2 + data['x3'] * x3 <= data['upper_bound'], name=r)


constraints = [
    (2.63*x1 + 1.7*x3 >= 20),
    (1.99*x2 + 1.7*x3 >= 10),
    (0.74*x0 + 1.7*x3 >= 7),
    (0.74*x0 + 2.63*x1 + 1.99*x2 >= 12),
    (0.74*x0 + 2.63*x1 + 1.7*x3 >= 12),
    (0.74*x0 + 2.63*x1 + 1.99*x2 >= 16),
    (0.74*x0 + 2.63*x1 + 1.7*x3 >= 16),
    (0.74*x0 + 2.63*x1 + 1.99*x2 + 1.7*x3 >= 16),
    # ... (rest of the constraints)
]

for i, constraint in enumerate(constraints):
    m.addConstr(constraint, name=f"c{i}")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

